<?php

namespace App\Http\Controllers\Admin;

use App\Categories;
use App\Http\Controllers\Controller;
use App\Posts;
use App\Sources;
use App\SubCategories;
use Illuminate\Support\Str;
use Input;
use Session;

class CategoryController extends Controller
{

    public function create()
    {
        return view('admin.categories.create');
    }

    public function store()
    {

        if (!Input::has('title')) {
            Session::flash('error_msg', 'Category title is required');
            return redirect()->back()->withInput(Input::all());
        }

        $category = new Categories();
        $category->title = Input::get('title');
        $category->slug = Str::slug(Input::get('title'));
        $category->scroll_type = Input::get('scroll_type', Categories::SCROLL_TYPE_PAGINATION);
        $category->show_in_menu = Input::has('show_in_menu') ? 1 : 0;
        $category->show_in_sidebar = Input::has('show_in_sidebar') ? 1 : 0;
        $category->show_in_footer = Input::has('show_in_footer') ? 1 : 0;
        $category->seo_keywords = Input::get('seo_keywords', Input::get('title'));
        $category->seo_description = Input::get('seo_description', Input::get('title'));
        $category->show_as_mega_menu = Input::has('show_as_mega_menu') ? 1 : 0;
        $category->save();

        Session::flash('success_msg', 'Category created successfully');
        return redirect()->to('/admin/categories/all');

    }

    public function edit($id)
    {

        if (!is_null($id) && sizeof(Categories::where('id', $id)->get()) > 0) {

            $category = Categories::where('id', $id)->first();
            return view('admin.categories.edit', ['category' => $category]);

        } else {
            Session::flash('error_msg', 'Category not found');
            return redirect()->to('/admin/categories/all');
        }

    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(Categories::where('id', $id)->get()) > 0) {

            Categories::where('id', $id)->delete();

            $sub_lists = SubCategories::where('parent_id', $id)->lists('id');

            if (sizeof($sub_lists) > 0) {
                Sources::whereIn('category_id', $sub_lists)->delete();
                Posts::whereIn('category_id', $sub_lists)->delete();
                SubCategories::where('parent_id', $id)->delete();
            }

            Session::flash('success_msg', 'Category deleted successfully');
            return redirect()->to('/admin/categories/all');

        } else {
            Session::flash('error_msg', 'Category not found');
            return redirect()->to('/admin/categories/all');
        }
    }

    public function update()
    {

        if (Input::has('id') && sizeof(Categories::where('id', Input::get('id'))->get()) > 0) {

            if (sizeof(Categories::where('title', Input::get('title'))->where('id', '!=', Input::get('id'))->get()) > 0) {
                Session::flash('error_msg', 'Category with given title already exists');
                return redirect()->back()->withInput(Input::all());
            }

            $category = Categories::where('id', Input::get('id'))->first();

            $category->title = Input::get('title');
            $category->slug = Str::slug(Input::get('title'));
            $category->scroll_type = Input::get('scroll_type', Categories::SCROLL_TYPE_PAGINATION);
            $category->show_in_menu = Input::has('show_in_menu') ? 1 : 0;
            $category->show_in_sidebar = Input::has('show_in_sidebar') ? 1 : 0;
            $category->show_in_footer = Input::has('show_in_footer') ? 1 : 0;
            $category->seo_keywords = Input::get('seo_keywords', Input::get('title'));
            $category->seo_description = Input::get('seo_description', Input::get('title'));
            $category->show_as_mega_menu = Input::has('show_as_mega_menu') ? 1 : 0;
            $category->save();

            Session::flash('success_msg', 'Category updated successfully');
            return redirect()->to('/admin/categories/all');

        } else {
            Session::flash('error_msg', 'Category not found');
            return redirect()->to('/admin/categories/all');
        }

    }

    public function all()
    {

        $categories = Categories::all();

        foreach ($categories as $category) {
            $category->no_sources = Sources::where('category_id', $category->id)->count();
            $category->no_posts = Posts::where('category_id', $category->id)->count();
        }

        return view('admin.categories.all', ['categories' => $categories]);
    }

}